<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'controllers/inbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Distribution_list_controller extends Inbox {
	
	/*Distribution list methods */
	public function create_list()
	{
		$this->load->library("form_validation");
		$this->load->library('audit'); 
		if($_GET['location'] == ""){
		$Location = "";
		} else {
		$Location = $_GET['location'];
		}
		$data['form'] = '/inbox/create_list/?location='.$Location;
		$data['location'] = $Location;
		if($this->form_validation->run('distribution_list') == true) {
			$name = $this->input->post("list_display_name",TRUE);
			$this->load->model('private_distribution_list_model');
			$values = array('name'=> $name,'description'=>$this->input->post("list_description",TRUE));
			$id = $this->private_distribution_list_model->create($values);
			if(!empty($id)){
				$this->edit_list($id);
			}
			else{
				$form_data = $this->input->post(NULL);
				$data['form_data'] = $form_data;
				$this->load->view("addressbook/add_distribution_list",$data);
			}
		}
		else {
			$form_data = $this->input->post(NULL);
			$form_data['list_display_name']=html_entity_decode($form_data['list_display_name'],ENT_QUOTES);
			if(isset($form_data['list_description'])){$form_data['list_description']=html_entity_decode($form_data['list_description'],ENT_QUOTES);}
			$data['form_data'] = $form_data;
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$data['validation_errors'] = $validation_errors;
			}
			$this->load->view("/addressbook/add_distribution_list",$data); //load view
		}
	}	
	
	public function edit_distribution_list() {
		$this->load->library("form_validation");
		$this->load->model('private_distribution_list_model','pubdistlist');
		$list_display_name = $this->input->post('list_display_name',TRUE);
		$list_description = $this->input->post('list_description',TRUE);
		$list_members = $this->input->post('list_members',TRUE);
		$list_id = $this->input->post('list_id',TRUE);
		if(!is_array($list_members) || count($list_members) === 0) { $list_members = array(); } //if no members, give empty array
		
		//set valdiation rules		
		if($this->form_validation->run('distribution_list') === TRUE) {
			//update display name and description
			$attributes = array(
				'name' => $list_display_name,
				'description' => $list_description,
			);
			 $this->pubdistlist->update($list_id,$attributes);
			//update addresses
			$addresses_in_list = $this->pubdistlist->addresses_for_list($list_id);
			$addresses_to_add = array_diff($list_members,$addresses_in_list);
			$addresses_to_remove = array_diff($addresses_in_list,$list_members);
			foreach($addresses_to_add as $address) {
				 $this->pubdistlist->add_address_to_list($list_id,$address);
			}
			foreach($addresses_to_remove as $address) {
				 $this->pubdistlist->remove_address_from_list($list_id,$address);
			}
		}
		else {
			//validation fails
			$form_data = $this->input->post(NULL);
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				echo json_encode($validation_errors);
			}
		}
	}
	
	public function edit_list($list_id)	{
		$Location = "";
		$this->load->library('audit'); 
		$this->load->model('private_distribution_list_model');
		if(!$this->private_distribution_list_model->formatted_like_an_id($list_id))
			show_404();
		$list=$this->private_distribution_list_model->find_one($list_id);
		if($list === false  || $list['created_by'] !== $this->user_model->logged_in_user('user_id')){
			show_404();
		}
		$data['list_id'] = $list_id;
		if($_GET['location'] == ""){
		$Location = "";
		} else {
		$Location = $_GET['location'];
		}
		$data['form'] = 'inbox/edit_distribution_list/?location='.$Location;
		$data['addresses'] = $this->private_distribution_list_model->addresses_for_list($list);
		$form_data = $this->input->post(NULL);
		$form_data['list_description']= $list['description'];
		$form_data['list_display_name']= $list['name'];
		$data['form_data'] = $form_data;
		
		//set up the options for the multiselect
		$user_options = array();
		foreach($this->get_contacts_search(null, true, false) as $user){
			$email = strtolower(trim($user['id']));
			$user_options[$email] =  $user['name'] . ' ('.$email.')';
		}
		
		$external_addresses = array_diff($data['addresses'], array_keys($user_options));
		foreach($external_addresses as $external_address){
			$user_options[$external_address] = $external_address;
		}
		natcasesort($user_options);		
		$data['user_options'] = $user_options;		
		
		$this->load->view("/addressbook/edit_distribution_list",$data); //load view
		
	}
		
	
	public function remove_list($list_id){
		$this->load->library("form_validation");
		$this->load->library('audit'); 
		if($list_id === null){
			show_404();
		}
		$this->load->model('private_distribution_list_model');
		$list=$this->private_distribution_list_model->find_one($list_id);
		if($list === false  || $list['created_by'] !== $this->private_distribution_list_model->logged_in_user_id()){
			show_404();
		}
		$this->private_distribution_list_model->delete($list_id);
	}
	
////////////////////////////////
// HELPER METHODS
////////////////////////////////	

	/* Used as a form validation callback to verify that the name is available for the list */
	// not protected so that the validator can reach it, but not intended to be web-accessible
	public function list_is_unique($name) {
		$this->load->model('private_distribution_list_model');
		$this->form_validation->set_message('list_is_unique', 'This %s is already in use.  Please choose another value.');
		
		$name_is_available = $this->private_distribution_list_model->name_is_available($name);
		if($name_is_available) return true;
			
		//if we're editing (edit_distribution_list or e), check to see if the name is being used by the list we're editing
		if(string_begins_with('edit', $this->router->method) && string_ends_with('distribution_list', $this->router->method)){
			$list = $this->private_distribution_list_model->find_one(compact('name'));
			return $list['id'] == $this->input->post('list_id');			
		}
		
		return $this->private_distribution_list_model->name_is_available($name);
	}		
	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */